local function readBytecodeFile(filename)
    local file = fs.open(filename, "r")
    if not file then
        print("File not found!")
        return nil
    end

    local bytecode = file.readAll()
    file.close()

    return bytecode
end

local function convertToHex(bytecode)
    local hexOutput = {}

    for i = 1, #bytecode do
        local byte = bytecode:sub(i, i):byte()
        table.insert(hexOutput, string.format("0x%02X", byte))
    end

    return hexOutput
end

local function displayHex(hexOutput, startIndex, endIndex)
    term.clear()
    term.setCursorPos(1, 1)

    for i = startIndex, endIndex do
        if hexOutput[i] then
            print(hexOutput[i])
        end
    end
end

local function main()
    print("Enter the filename of the bytecode file:")
    local filename = read()
    local bytecode = readBytecodeFile(filename)

    if bytecode then
        local hexOutput = convertToHex(bytecode)
        local startIndex = 1
        local endIndex = 20
        local scroll = 0

        displayHex(hexOutput, startIndex, endIndex)

        while true do
            local event, key = os.pullEvent()

            if event == "key" then
                if key == keys.up then
                    if startIndex > 1 then
                        startIndex = startIndex - 1
                        endIndex = endIndex - 1
                        displayHex(hexOutput, startIndex, endIndex)
                    end
                elseif key == keys.down then
                    if endIndex < #hexOutput then
                        startIndex = startIndex + 1
                        endIndex = endIndex + 1
                        displayHex(hexOutput, startIndex, endIndex)
                    end
                elseif key == keys.q then
                    break
                end
            end
        end
    end
end

main()